<?php
$data = json_decode(file_get_contents('menu.json'), true);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Menu Board 2</title>
    <link rel="stylesheet" href="style.css?v=7">
    <script src="auto_update.js"></script>
</head>
<body>
    <div class="header-bar">
        <div class="brand">KING PIZZERIA</div>
        <div class="subtitle">Calzones &bull; Stromboli &bull; Specialty Pizza &bull; Subs</div>
    </div>
    <div class="content">
        <div class="main">
            <div class="col">
                <div class="menu-block">
                    <h1>Calzones</h1>
                    <div class="two-col-list">
                        <ul>
                            <?php foreach ($data['calzones']['left_column'] as $item): ?>
                                <li><?= htmlspecialchars($item) ?></li>
                            <?php endforeach; ?>
                        </ul>
                        <ul>
                            <?php foreach ($data['calzones']['right_column'] as $item): ?>
                                <li><?= htmlspecialchars($item) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="highlight-bar centered">
                        Small $<?= number_format($data['calzones']['price_small'], 2) ?>
                        &nbsp;&nbsp; Large $<?= number_format($data['calzones']['price_large'], 2) ?>
                    </div>
                </div>

                <div class="menu-block">
                    <h1>Stromboli</h1>
                    <div class="two-col-list">
                        <ul>
                            <?php foreach ($data['stromboli']['left_column'] as $item): ?>
                                <li><?= htmlspecialchars($item) ?></li>
                            <?php endforeach; ?>
                        </ul>
                        <ul>
                            <?php foreach ($data['stromboli']['right_column'] as $item): ?>
                                <li><?= htmlspecialchars($item) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="highlight-bar centered">
                        Small $<?= number_format($data['stromboli']['price_small'], 2) ?>
                        &nbsp;&nbsp; Large $<?= number_format($data['stromboli']['price_large'], 2) ?>
                    </div>
                </div>
            </div>
                    <div class="highlight-bar" style="margin-top:26px;">Deluxe Pizzas</div>
                    <div class="small-text">
                        <?php foreach ($data['deluxe_pizzas'] as $dp): ?>
                            <div style="margin-top:10px;">
                                <strong><?= htmlspecialchars($dp['name']) ?></strong><br>
                                <span><?= htmlspecialchars(implode(', ', $dp['toppings'])) ?></span><br>
                                <span>Available in <?= htmlspecialchars(implode(', ', $dp['sizes'])) ?></span>
                            </div>
                        <?php endforeach; ?>
                    </div>


            <div class="col">
                <div class="menu-block">
                    <h1>Specialty Pizza</h1>
                    <div class="three-col-list">
                        <?php
                        $items = $data['specialty_pizza']['items'];
                        $third = (int)ceil(count($items)/3);
                        $chunks = array_chunk($items, $third);
                        foreach ($chunks as $chunk):
                        ?>
                        <ul>
                            <?php foreach ($chunk as $item): ?>
                                <li><?= htmlspecialchars($item) ?></li>
                            <?php endforeach; ?>
                        </ul>
                        <?php endforeach; ?>
                    </div>

                    <div class="subheading">Prices</div>
                    <div class="small-text">
                        <?php
                            $parts = [];
                            foreach ($data['specialty_pizza']['prices'] as $size => $price) {
                                $parts[] = htmlspecialchars($size) . ' - $' . number_format($price, 2);
                            }
                            echo implode(' • ', $parts);
                        ?>
                    </div>

                    <div class="subheading">Flavored Crust</div>
                    <div class="small-text">
                        <?= htmlspecialchars(implode(' • ', $data['specialty_pizza']['flavored_crust'])) ?>
                    </div>

                    <div class="subheading">Crust</div>
                    <div class="small-text">
                        <?= htmlspecialchars(implode(' • ', $data['specialty_pizza']['crust'])) ?>
                    </div>
                </div>

                <div class="menu-block">
                    <h1>Subs</h1>
                    <div class="two-col-list" style="font-size:30px;">
                        <?php
                        $sitems = $data['subs']['items'];
                        $half = (int)ceil(count($sitems)/2);
                        $chunks = array_chunk($sitems, $half);
                        foreach ($chunks as $chunk):
                        ?>
                        <ul>
                            <?php foreach ($chunk as $item): ?>
                                <li><?= htmlspecialchars($item) ?></li>
                            <?php endforeach; ?>
                        </ul>
                        <?php endforeach; ?>
                    </div>
                    <div class="subheading">Prices</div>
                    <div class="small-text">
                        9&quot; Sub $<?= number_format($data['subs']['sub_price_9in'], 2) ?>
                        &nbsp;&bull;&nbsp;
                        Baked Fries $<?= number_format($data['subs']['baked_fries'], 2) ?>
                    </div>

                    <div class="feature-card">
                        <div class="feature-card-title">Featured Dessert Pizza</div>
                        <div class="feature-card-subtitle">Nutella Pizza &nbsp;&bull;&nbsp; $9.99</div>
                        <div class="feature-card-desc">
                            Warm hand-tossed crust topped with creamy Nutella, powdered sugar,
                            and a drizzle of chocolate. Perfect to share after your meal.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
