<?php
$data = json_decode(file_get_contents('menu.json'), true);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Menu Board 1</title>
    <link rel="stylesheet" href="style.css?v=7">
    <script src="auto_update.js"></script>
</head>
<body>
    <div class="header-bar">
        <div class="brand">KING PIZZERIA</div>
        <div class="subtitle">Desserts &bull; Pasta &bull; Wings &bull; Salads &bull; Appetizers</div>
    </div>
    <div class="content">
        <div class="main">
            <div class="col">
                <div class="menu-block">
                    <h1>Desserts</h1>
                    <?php foreach ($data['desserts']['items'] as $name => $price): ?>
                        <div class="menu-line">
                            <span><?= htmlspecialchars($name) ?></span>
                            <span>$<?= number_format($price, 2) ?></span>
                        </div>
                    <?php endforeach; ?>
                    <div class="section-note">
                        <?= htmlspecialchars($data['desserts']['note']) ?>
                    </div>
                </div>

                <div class="menu-block">
                    <h2>Pasta Dinners</h2>
                    <?php foreach ($data['pasta_dinners']['items'] as $name => $price): ?>
                        <div class="menu-line">
                            <span><?= htmlspecialchars($name) ?></span>
                            <span>$<?= number_format($price, 2) ?></span>
                        </div>
                    <?php endforeach; ?>
                    <?php foreach ($data['pasta_dinners']['add_ons'] as $name => $price): ?>
                        <div class="menu-line small-text">
                            <span><?= htmlspecialchars($name) ?></span>
                            <span>$<?= number_format($price, 2) ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div class="menu-block">
                    <h2>Baked Wings</h2>
                    <div class="two-col-list">
                        <div>
                            <h3>Original</h3>
                            <ul>
                            <?php foreach ($data['wings']['original'] as $qty => $price): ?>
                                <li><?= $qty ?> - $<?= number_format($price, 2) ?></li>
                            <?php endforeach; ?>
                            </ul>
                        </div>
                        <div>
                            <h3>Boneless</h3>
                            <ul>
                            <?php foreach ($data['wings']['boneless'] as $qty => $price): ?>
                                <li><?= $qty ?> - $<?= number_format($price, 2) ?></li>
                            <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>

                    <div class="highlight-bar">1. Choose Your Wing</div>
                    <div class="small-text">Original &bull; Boneless</div>

                    <div class="highlight-bar">2. Choose Your Flavor</div>
                    <div class="small-text">
                        Honey BBQ &bull; Garlic Parmesan &bull; Mild &bull; Hot &bull; BBQ &bull; Teriyaki &bull;
                        Lemon Pepper &bull; Honey Mustard &bull; Dry
                    </div>

                    <div class="highlight-bar">3. Add Your Dip</div>
                    <div class="small-text">Ranch &bull; Blue Cheese</div>

                    <div class="highlight-bar">4. Optional Options</div>
                    <div class="small-text">
                        Drums or Flats 10&cent; each &bull;
                        Splits $<?= number_format($data['wings']['options']['Splits'], 2) ?>
                    </div>
                </div>
            </div>

            <div class="col">
                <div class="menu-block">
                    <h1>Fresh Garden Salads</h1>
                    <?php foreach ($data['salads']['items'] as $name => $price): ?>
                        <div class="menu-line small-text">
                            <span><?= htmlspecialchars($name) ?></span>
                            <span>$<?= number_format($price, 2) ?></span>
                        </div>
                    <?php endforeach; ?>
                    <div class="subheading">Dressing</div>
                    <div class="small-text">
                        <?= htmlspecialchars(implode(' • ', $data['salads']['dressings'])) ?>
                    </div>
                </div>

                <div class="menu-block">
                    <h2>Gyros</h2>
                    <?php foreach ($data['gyros']['items'] as $name => $price): ?>
                        <div class="menu-line small-text">
                            <span><?= htmlspecialchars($name) ?></span>
                            <span>$<?= number_format($price, 2) ?></span>
                        </div>
                    <?php endforeach; ?>
                    <div class="small-text" style="margin-top: 10px;">
                        Extra:
                        <?php
                        $extras = [];
                        foreach ($data['gyros']['extras'] as $name => $price) {
                            $extras[] = htmlspecialchars($name) . ' $' . number_format($price, 2);
                        }
                        echo implode(' • ', $extras);
                        ?>
                    </div>
                </div>

                <div class="menu-block">
                    <h2>Appetizers</h2>
                    <?php foreach ($data['appetizers']['items'] as $name => $price): ?>
                        <div class="menu-line small-text">
                            <span><?= htmlspecialchars($name) ?></span>
                            <span>$<?= number_format($price, 2) ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
